# defines
#MAKEDEP	=linux.mak
INCDIR	=inc
AS	=as -I$(INCDIR)
CC	=gcc -c -g -Wall -W -O2 -I$(INCDIR) -nostdinc -fno-builtin
KOBJS	=kstart.o main.o video.o vga.o kbd.o
LOBJS	=lib/doprintf.o lib/memsetw.o lib/outportb.o lib/inportb.o\
	lib/strlen.o lib/memcpy.o
LIB	=lib/libc.a
LDSCRIPT=krnl.ld

# targets
all :	krnl.x

clean :
	deltree /y krnl.x krnl.lst krnl.sym *.o lib\libc.a lib\*.o

# implicit rules
.c.o :
	$(CC) -c -o$@ $<

.s.o :
	$(AS) -o$@ $<

# dependencies
kstart.o : kstart.s $(MAKEDEP)

main.o : main.c $(MAKEDEP)

video.o : video.c $(MAKEDEP)

vga.o : vga.c $(MAKEDEP)

kbd.o : kbd.c $(MAKEDEP)

lib/doprintf.o : lib/doprintf.c $(MAKEDEP)

lib/memsetw.o : lib/memsetw.c $(MAKEDEP)

lib/outportb.o : lib/outportb.c $(MAKEDEP)

lib/inportb.o : lib/inportb.c $(MAKEDEP)

lib/strlen.o : lib/strlen.c $(MAKEDEP)

lib/memcpy.o : lib/memcpy.c $(MAKEDEP)

# explicit rules
$(LIB) : $(LOBJS)
	ar rcs $(LIB) $(LOBJS)

krnl.x : $(KOBJS) $(LDSCRIPT) $(LIB) $(MAKEDEP)
	ld -g -Ttext=0x100000 -T $(LDSCRIPT) -o$@ $(KOBJS) $(LIB)
	objdump --source $@ >krnl.lst
	nm -n --line-numbers $@ >krnl.sym
	strip $@
