/*----------------------------------------------------------------------------
ASM COMPONENT OF KERNEL

EXPORTS
extern mboot_info_t *g_mboot_info;
----------------------------------------------------------------------------*/

.include "as.inc"

/* IMPORTS
from MAIN.C */
IMP kmain

/* from linker script */
IMP g_code
IMP g_bss
IMP g_end

/*****************************************************************************
kernel entry point -- start here from bootloader
*****************************************************************************/

.globl entry
entry:

/* check if bootloader is compatible with Multiboot (e.g. GRUB) */
	cmp $0x2BADB002,%eax
	je mb_ok

/* display a blinking white-on-blue 'B' if bad bootloader */
	movw $0x9F42,(0xB8000)
	jmp .
mb_ok:

/* load new GDT */
	lgdt (gdt_ptr)
/*	ljmp $KERNEL_CS,$new_gdt	stupid assembler */
	.byte 0xEA
	.long new_gdt
	.word KERNEL_CS
new_gdt:
	mov $KERNEL_DS,%ax
	mov %eax,%ds
	mov %eax,%ss
	mov %eax,%es
	mov %eax,%fs
	mov %eax,%gs

/* save pointer to g_mboot_info (in EBX) */
	mov %ebx,(g_mboot_info)

/* set up pmode stack */
	mov $stack,%esp

	call kmain		/* jump to C kernel */
	jmp .

/*****************************************************************************
Multiboot header, with "aout kludge"
GRUB will not boot the kernel unless
- this structure is present within the first 8192 bytes of the kernel file
- this structure is aligned on a 4-byte boundary
- the Multiboot magic value is present in the structure
- the checksum in the structure is correct
*****************************************************************************/

.equ	MBOOT_PAGE_ALIGN, 1<<0
.equ	MBOOT_MEMORY_INFO, 1<<1
.equ	MBOOT_AOUT_KLUDGE, 1<<16
.equ	MBOOT_HEADER_MAGIC, 0x1BADB002
.equ	MBOOT_HEADER_FLAGS, MBOOT_PAGE_ALIGN | MBOOT_MEMORY_INFO | MBOOT_AOUT_KLUDGE
.equ	MBOOT_CHECKSUM, -(MBOOT_HEADER_MAGIC + MBOOT_HEADER_FLAGS)

.p2align 2
mboot:
	.long MBOOT_HEADER_MAGIC
	.long MBOOT_HEADER_FLAGS
	.long MBOOT_CHECKSUM
/* aout kludge */
	.long mboot
	.long g_code
	.long g_bss
	.long g_end
	.long entry

/*****************************************************************************
kernel .data
*****************************************************************************/

.section .data

/* null descriptor. gdt_ptr could be put here to save a few bytes,
but that can be confusing */
gdt:
	.word 0		/* limit 15:0 */
	.word 0		/* base 15:0 */
	.byte 0		/* base 23:16 */
	.byte 0		/* type */
	.byte 0		/* limit 19:16, flags */
	.byte 0		/* base 31:24 */

/* unused descriptor */
	.long 0, 0

/* ring 0 kernel code segment descriptor */
.equ	KERNEL_CS,(.-gdt)
gdt_kcode:
	.word 0xFFFF
	.word 0
	.byte 0
	.byte 0x9A	/* present,ring 0,code,non-conforming,readable */
	.byte 0xCF
	.byte 0

/* ring 0 kernel data segment descriptor */
.equ	KERNEL_DS,(.-gdt)
gdt_kdata:
	.word 0xFFFF
	.word 0
	.byte 0
	.byte 0x92	/* present,ring 0,data,expand-up,writable */
	.byte 0xCF
	.byte 0
gdt_end:

gdt_ptr:
	.word gdt_end - gdt - 1	/* GDT limit */
	.long gdt		/* linear adr of GDT (set above) */

/*****************************************************************************
kernel .bss
*****************************************************************************/

.section .bss

	.long 0
	.p2align 12
stack:

EXP g_mboot_info
	.long 0
