/* let the linker use its 'native' format (ELF/COFF/PE)
OUTPUT_FORMAT("coff-go32") */
/* no leading underscores for symbols handled in asm: */
ENTRY(entry)
load_adr = 0x100000; /* 1 meg = physical address */
SECTIONS
{
/* must use "ld -Ttext=NNN ..." to set starting virtual address */
    .text : AT(load_adr)
    {
/* kernel code */
	g_code = .; _g_code = .;
	*(.text*)
/* ELF constant data section(s) */
	*(.rodata*)
	. = ALIGN(4096);
    }
    .data : AT(load_adr + (g_data - g_code))
    {
/* kernel data */
	g_data = .; _g_data = .;
	*(.data*)
	. = ALIGN(4096);
    }
    .bss : AT(load_adr + (g_bss - g_code))
    {
/* kernel BSS */
	g_bss = .; _g_bss = .;
	*(.bss*)
	*(COMMON) /* "common" variables */
	. = ALIGN(4096);
    }
/* end of kernel */
    g_end = .; _g_end = .;
/* MinGW debug sections
Omit these and you get an invalid executable file */
    .stab :
    {
	*(.stab)
    }
    .stabstr :
    {
	*(.stabstr)
    }
}
