# defines
MAKEFILE=watcom16.mak
# MAKEDEP	=$(MAKEFILE)
CC	=wcc -zq -s -d2 -hw -ox -w=9 -zc -ms -fr=nul
AS	=nasm -f obj -d__WATCOMC__=1
LD	=wlink OP q D w a SYS dos
TCP_SRV	=tcp-srv.obj vxdsock.obj callsock.obj
TCP_CLI	=tcp-cli.obj vxdsock.obj callsock.obj
UDP_SRV	=udp-srv.obj vxdsock.obj callsock.obj
UDP_CLI	=udp-cli.obj vxdsock.obj callsock.obj

# targets
all : tcp-srv.exe udp-srv.exe udp-cli.exe
# tcp-cli.exe

clean : .SYMBOLIC
	deltree /y *.obj *.o *.exe

# implicit rules
.c.obj : .AUTODEPEND
	$(CC) -fo=$*.obj $[@

.asm.obj : .AUTODEPEND
	$(AS) -o$*.obj $[@

# dependencies
vxdsock.obj :	vxdsock.c	socket.h	$(MAKEDEP)

tcp-srv.obj :	tcp-srv.c	socket.h	$(MAKEDEP)

udp-srv.obj :	udp-srv.c	socket.h	$(MAKEDEP)

udp-cli.obj :	udp-cli.c	socket.h	$(MAKEDEP)

# explicit rules
tcp-srv.exe : $(TCP_SRV) $(MAKEDEP)
	$(LD) N tcp-srv.exe F tcp-srv.obj F vxdsock.obj F callsock.obj

tcp-cli.exe : $(TCP_CLI) $(MAKEDEP)
	$(LD) N tcp-cli.exe F tcp-cli.obj F vxdsock.obj F callsock.obj

udp-srv.exe : $(UDP_SRV) $(MAKEDEP)
	$(LD) N udp-srv.exe F udp-srv.obj F vxdsock.obj F callsock.obj

udp-cli.exe : $(UDP_CLI) $(MAKEDEP)
	$(LD) N udp-cli.exe F udp-cli.obj F vxdsock.obj F callsock.obj
