/*****************************************************************************
Socket library for Turbo C and 16-bit Watcom C that calls WSOCK[2].VXD

This code must be run inside a Windows 9x DOS box, preferably Win95
(WinSock version 1). It will not work in a Windows NT/2k/XP DOS box.

Copyright (C) 2003 by Chris Giese
<geezer@execpc.com>, http://my.execpc.com/~geezer

Based on Berci Gabor's Turbo Pascal code for accessing WSOCK2.VXD
http://www.phekda.freeserve.co.uk/gabor/ws2dos/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************************/
#include <stdlib.h> /* atexit() */
#include <string.h> /* NULL, memset() */
#include <stdio.h> /* printf() */
#include <errno.h> /* errno */
#include <time.h> /* time() */
#include "socket.h"

#if defined(__TURBOC__)
#define	FAR	far

/* 32-bit Watcom C and DJGPP are not (yet) supported */
#elif defined(__WATCOMC__)
#if defined(__386__)
#error This is a 16-bit program. Compile with WCC.EXE
#endif

#define	FAR	far

/* #elif defined(__DJGPP__)
#define	FAR	nothing */

#else
#error Sorry, unsupported compiler
#endif

/* IMPORTS
from CALLSOCK.ASM */
extern char g_wsock2;
/* need 'cdecl' for Watcom C, to force stack calling convention */
int cdecl call_wsock_vxd(unsigned fn, void FAR *params, unsigned size);
/*----------------------------------------------------------------------------
SOCKET API
----------------------------------------------------------------------------*/
typedef struct
{
	char used;
	uint32_t winsock_handle;
} sock_t;

static sock_t g_sockets[MAX_SOX];
/*****************************************************************************
*****************************************************************************/
unsigned swap16(unsigned arg)
{
	return ((arg >> 8) & 0x00FF) | ((arg << 8) & 0xFF00);
}
/*****************************************************************************
*****************************************************************************/
unsigned long swap32(unsigned long arg)
{
	return ((arg >> 24) & 0x00FF) | ((arg >> 8) & 0xFF00) |
		((arg << 8) & 0x00FF0000L) | ((arg << 24) & 0xFF000000L);
}
/*****************************************************************************
*****************************************************************************/
static int alloc_sock(void)
{
	unsigned i;

	for(i = 0; i < MAX_SOX; i++)
	{
		if(g_sockets[i].used)
			continue;
		g_sockets[i].used = 1;
		return i;
	}
	return -1;
}
/*****************************************************************************
*****************************************************************************/
static void free_sock(unsigned s)
{
	if(s >= MAX_SOX)
		return;
	g_sockets[s].used = 0;
}
/*****************************************************************************
*****************************************************************************/
int socket(int family, int type, int protocol)
{
#pragma pack(1)
	struct
	{
		uint32_t family;
		uint32_t type;
		uint32_t protocol;
		uint32_t winsock_handle;
		uint32_t random;
/* extra fields for WSOCK2.VXD */
		uint32_t protocol_catalog_id;
		uint32_t group_id;
		uint32_t flags;
	} params;
	int s, i;

	memset(&params, 0, sizeof(params));
	params.family = family;
	params.type = type;
	params.protocol = protocol;
	params.random = (uint32_t)time(NULL);
	i = call_wsock_vxd(0x110, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	s = alloc_sock();
	if(s < 0)
		return s;
	g_sockets[s].winsock_handle = params.winsock_handle;
printf("socket(): allocated socket %d with Winsock handle=0x%lX\n",
 s, g_sockets[s].winsock_handle);
	return s;
}
/*****************************************************************************
*****************************************************************************/
int shutdown(int s, int how)
{
#pragma pack(1)
	struct
	{
		uint32_t winsock_handle;
		uint32_t how;
	} params;
	int i;

	memset(&params, 0, sizeof(params));
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.how = how;
	i = call_wsock_vxd(0x10F, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	return 0;
}
/*****************************************************************************
*****************************************************************************/
int closesocket(int s)
{
#pragma pack(1)
	struct
	{
		uint32_t winsock_handle;
	} params;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in closesocket()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.winsock_handle = g_sockets[s].winsock_handle;
	i = call_wsock_vxd(0x102, &params, sizeof(params));
printf("closesocket(%d); Winsock handle=0x%lX\n",
 s, g_sockets[s].winsock_handle);
	free_sock(s);
	return i;
}
/*****************************************************************************
*****************************************************************************/
int bind(int s, const struct sockaddr *my_adr, int adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *my_adr;
		uint32_t winsock_handle;
		uint32_t adr_len;
		void FAR *apc_routine;
		uint32_t apc_context;
/* extra fields for WSOCK2.VXD */
		uint32_t conn_family;
	} params;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in bind()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.my_adr = my_adr;
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.adr_len = adr_len;
	i = call_wsock_vxd(0x101, &params, sizeof(params));
	return i;
}
/*****************************************************************************
*****************************************************************************/
int listen(int s, int backlog)
{
#pragma pack(1)
	struct
	{
		uint32_t winsock_handle;
		uint32_t backlog;
	} params;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in listen()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.backlog = backlog;
	i = call_wsock_vxd(0x108, &params, sizeof(params));
	return i;
}
/*****************************************************************************
*****************************************************************************/
int accept(int s, struct sockaddr *their_adr, int *adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *their_adr;
		uint32_t listen_winsock_handle;
		uint32_t connect_winsock_handle;
		uint32_t adr_len;
		uint32_t random;
		void FAR *apc_routine;
		uint32_t apc_context;
/* extra fields for WSOCK2.VXD */
		uint32_t accept_family;
		uint32_t get_ext_info;
		uint32_t unknown;
		void FAR *local_name_ptr;
		uint32_t local_name_len;
		void FAR *peer_name_ptr;
		uint32_t peer_name_len;
		uint32_t unknown2;
	} params;
	int i, cs;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in accept()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.their_adr = their_adr;
	params.listen_winsock_handle = g_sockets[s].winsock_handle;
	params.adr_len = *adr_len;
	params.random = (uint32_t)time(NULL);
	i = call_wsock_vxd(0x100, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	cs = alloc_sock();
	if(cs < 0)
		return cs;
	g_sockets[cs].winsock_handle = params.connect_winsock_handle;
	*adr_len = params.adr_len;
printf("accept(): allocated socket %d with Winsock handle=0x%lX\n",
 cs, g_sockets[cs].winsock_handle);
	return cs;
}
/*****************************************************************************
*****************************************************************************/
int connect(int s, const struct sockaddr *their_adr, int adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *their_adr;
		uint32_t winsock_handle;
		uint32_t adr_len;
		void FAR *apc_routine;
		uint32_t apc_context;
/* extra fields for WSOCK2.VXD */
		uint32_t conn_event;
	} params;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in connect()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.their_adr = their_adr;
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.adr_len = adr_len;
	i = call_wsock_vxd(0x103, &params, sizeof(params));
	return i;
}
/*****************************************************************************
the data structures used by sendto() and recvfrom() are different enough
between WSOCK.VXD and WSOCK2.VXD that we need two different functions
*****************************************************************************/
static int ws1_sendto(int s, const char *buf, int buf_len, int flags,
		const struct sockaddr *their_adr, int adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *buf;
		void FAR *their_adr;
		uint32_t winsock_handle;
		uint32_t buf_len;
		uint32_t flags;
		uint32_t adr_len;
		uint32_t bytes_sent;
		void FAR *apc_routine;
		uint32_t apc_context;
		uint32_t timeout;
	} params;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in ws1_sendto()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.buf = buf;
	params.their_adr = their_adr;
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.buf_len = buf_len;
	params.flags = flags;
	params.adr_len = adr_len;
	i = call_wsock_vxd(0x10D, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	return params.bytes_sent;
}
/*****************************************************************************
call getpeername() with a bogus socket value (params.winsock_handle = 0)
to determine how Winsock2 converts 16:16 real-mode address 'adr'
to a 32-bit "flat" address
*****************************************************************************/
static void FAR *translate_ws2_adr(void FAR *adr)
{
#pragma pack(1)
	struct
	{
		void FAR *adr;
		uint32_t winsock_handle;
		uint32_t adr_len;
	} params;

	memset(&params, 0, sizeof(params));
	params.adr = adr;
	(void)call_wsock_vxd(0x104, &params, sizeof(params));
	return params.adr;
}
/*****************************************************************************
*****************************************************************************/
#define BPERL		16	/* byte/line for dump */

static void dump(unsigned char *data, unsigned count)
{
	unsigned char byte1, byte2;

	while(count != 0)
	{
		for(byte1 = 0; byte1 < BPERL; byte1++)
		{
			if(count == 0)
				break;
			printf("%02X ", data[byte1]);
			count--;
		}
		printf("\t");
		for(byte2 = 0; byte2 < byte1; byte2++)
		{
			if(data[byte2] < ' ')
				putchar('.');
			else
				putchar(data[byte2]);
		}
		printf("\n");
		data += BPERL;
	}
}
/*****************************************************************************
*****************************************************************************/
static int ws2_sendto(int s, const char *buf, int buf_len, int flags,
		const struct sockaddr *their_adr, int adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *buf_chain;
		void FAR *their_adr;
		uint32_t winsock_handle;
		uint32_t buf_count;
		void FAR *adr_len_ptr;
		uint32_t flags;
		uint32_t adr_len;
		uint32_t bytes_sent;
		void FAR *apc_routine;
		uint32_t apc_context;
		uint32_t unknown[3];
	} params;
#pragma pack(1)
	struct
	{
		uint32_t buf_len;
		void FAR *buf;
	} buf_chain;
	uint32_t dummy;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in sendto()\n", s);
		return -1;
	}
	buf_chain.buf_len = buf_len;
	buf_chain.buf = translate_ws2_adr(buf);

	memset(&params, 0, sizeof(params));
	params.their_adr = their_adr;
	params.adr_len = adr_len;
// xxx - trouble here?
dummy = adr_len;
params.adr_len_ptr = translate_ws2_adr(&dummy);//adr_len;
	params.buf_chain = &buf_chain;
	params.buf_count = 1;
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.bytes_sent = buf_len;
	params.flags = flags;

//dump((unsigned char *)&buf_chain, sizeof(buf_chain));
//printf("DS=0x%X, &buf_chain=%p, their_adr=%p, winsock_handle=0x%lX, buf_count=%ld, "
// "&dummy=%p\n",
//_DS, &buf_chain, their_adr, g_sockets[s].winsock_handle, params.buf_count, &dummy);
//dump((unsigned char *)&params, sizeof(params));


/* the addresses "params.buf_chain" and "params.adr" are translated to
32-bit flat pointers, "params.bytes_sent" is zeroed, everything else
(including "params.adr_len_ptr", and all of "buf_chain") is unchanged */

	i = call_wsock_vxd(0x10D, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	return params.bytes_sent;
}
/*****************************************************************************
*****************************************************************************/
int sendto(int s, const char *buf, int buf_len, int flags,
		const struct sockaddr *their_adr, int adr_len)
{
	if(g_wsock2)
		return ws2_sendto(s, buf, buf_len, flags, their_adr, adr_len);
	/* else */
	return ws1_sendto(s, buf, buf_len, flags, their_adr, adr_len);
}
/*****************************************************************************
*****************************************************************************/
int send(int s, const char *buf, int buf_len, int flags)
{
	return sendto(s, buf, buf_len, flags, NULL, 0);
}
/*****************************************************************************
*****************************************************************************/
static int ws1_recvfrom(int s, char *buf, int max_len, int flags,
		struct sockaddr *their_adr, int *adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *buf;
		void FAR *their_adr;
		uint32_t winsock_handle;
		uint32_t buf_len;
		uint32_t flags;
		uint32_t adr_len;
		uint32_t bytes_recvd;
		void FAR *apc_routine;
		uint32_t apc_context;
		uint32_t timeout;
	} params;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in ws1_recvfrom()\n", s);
		return -1;
	}
	memset(&params, 0, sizeof(params));
	params.buf = buf;
	params.their_adr = their_adr;
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.buf_len = max_len;
	params.flags = flags;
	params.adr_len = *adr_len;
params.bytes_recvd = max_len;
	i = call_wsock_vxd(0x109, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	return params.bytes_recvd;
}
/*****************************************************************************
*****************************************************************************/
static int ws2_recvfrom(int s, char *buf, int max_len, int flags,
		struct sockaddr *their_adr, int *adr_len)
{
#pragma pack(1)
	struct
	{
		void FAR *buf_chain;
		void FAR *their_adr;
		void FAR *adr_len_ptr;
		uint32_t winsock_handle;
		uint32_t buf_count;
		uint32_t adr_len;
		uint32_t flags;
		uint32_t bytes_recvd;
		void FAR *apc_routine;
		uint32_t apc_context;
		uint32_t unknown[4];
	} params;
#pragma pack(1)
	struct
	{
		uint32_t buf_len;
		void FAR *buf;
	} buf_chain;
	int i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in ws2_recvfrom()\n", s);
		return -1;
	}
	buf_chain.buf_len = max_len;
	buf_chain.buf = translate_ws2_adr(buf);

	memset(&params, 0, sizeof(params));
	params.buf_chain = &buf_chain;
	params.their_adr = their_adr;
// not for recv():
//	params.adr_len_ptr = adr_len;
	params.winsock_handle = g_sockets[s].winsock_handle;
	params.buf_count = 1;
	params.adr_len = *adr_len;
	params.flags = flags;
	i = call_wsock_vxd(0x109, &params, sizeof(params));
	if(i != 0)
	{
		if(i == -1)
			errno = 0;
		else
			errno = i;
		return -1;
	}
	errno = 0;
	return params.bytes_recvd;
}
/*****************************************************************************
*****************************************************************************/
int recvfrom(int s, char *buf, int max_len, int flags,
		struct sockaddr *their_adr, int *adr_len)
{
	if(g_wsock2)
		return ws2_recvfrom(s, buf, max_len, flags,
			their_adr, adr_len);
	/* else */
	return ws1_recvfrom(s, buf, max_len, flags, their_adr, adr_len);
}
/*****************************************************************************
*****************************************************************************/
int recv(int s, char *buf, int max_len, int flags)
{
	int zero = 0;

	return recvfrom(s, buf, max_len, flags, NULL, &zero);
}
/*****************************************************************************
*****************************************************************************/
#if !defined(__DJGPP__)
void FD_ZERO(fd_set *arg)
{
	memset(arg, 0, sizeof(fd_set));
}
/*****************************************************************************
xxx - this now works but, if you select() on multiple fd's,
there's no way to determine which fd caused the event
*****************************************************************************/
void FD_SET(int s, fd_set *arg)
{
	unsigned i;

	if(s >= MAX_SOX)
	{
printf("Bad socket %d in FD_SET()\n", s);
		return;
	}
/* find first fd with zero winsock_handle, and use it */
	for(i = 0; i < MAX_SOX; i++)
	{
		if((*arg)[i].winsock_handle == 0)
		{
			(*arg)[i].winsock_handle = g_sockets[s].winsock_handle;
			return;
		}
	}
}
/*****************************************************************************
*****************************************************************************/
static unsigned count_nonzero_fds(int num_fds, fd_set *arg)
{
	unsigned i, rv = 0;

	for(i = 0; i < num_fds; i++)
	{
		if((*arg)[i].winsock_handle != 0)
			rv++;
	}
	return rv;
}
/*****************************************************************************
xxx - no timeout

#define WSOCK_SELECT_SETUP_CMD      (WSOCK_FIRST_CMD + 0x000a)
typedef struct _WSOCK_SELECT_SETUP_PARAMS {
    LPSOCK_LIST ReadList;
    LPSOCK_LIST WriteList;
    LPSOCK_LIST ExceptList;
    DWORD       ReadCount;
    DWORD       WriteCount;
    DWORD       ExceptCount;
    LPVOID      ApcRoutine;
    DWORD       ApcContext;
} WSOCK_SELECT_SETUP_PARAMS;

#define WSOCK_SELECT_CLEANUP_CMD    (WSOCK_FIRST_CMD + 0x000b)
typedef struct _WSOCK_SELECT_CLEANUP_PARAMS {
    LPSOCK_LIST ReadList;
    LPSOCK_LIST WriteList;
    LPSOCK_LIST ExceptList;
    DWORD       ReadCount;
    DWORD       WriteCount;
    DWORD       ExceptCount;
} WSOCK_SELECT_CLEANUP_PARAMS;

typedef struct _SOCK_LIST FAR * LPSOCK_LIST;

typedef struct _SOCK_LIST {
    LPSOCK_INFO Socket;             // the target socket
    DWORD       EventMask;          // events the client is interested in
    DWORD       Context;            // user-defined context value (handle?)
} SOCK_LIST;
*****************************************************************************/
int select(int num_fds, fd_set *read_fds, fd_set *write_fds,
		fd_set *except_fds, struct timeval *timeout)
{
#pragma pack(1)
	struct
	{
		void FAR *read_list;
		void FAR *write_list;
		void FAR *except_list;
		uint32_t read_count;
		uint32_t write_count;
		uint32_t except_count;
/* these are used by select setup, but not by select cleanup */
		void FAR *apc_routine;
		uint32_t apc_context;
	} params;
	int i;

	memset(&params, 0, sizeof(params));
	if(read_fds != NULL)
	{
		for(i = 0; i < num_fds; i++)
		{
			if((*read_fds)[i].winsock_handle != 0)
/* see WINSOCK.H for FD_... values
0x0019 = FD_CONNECT, FD_ACCEPT, FD_READ */
				(*read_fds)[i].event_mask = 0x0019;
		}
		params.read_list = *read_fds;
		params.read_count = count_nonzero_fds(num_fds, read_fds);
	}
	if(write_fds != NULL)
	{
		for(i = 0; i < num_fds; i++)
		{
			if((*write_fds)[i].winsock_handle != 0)
/* 0x0002 = FD_WRITE */
				(*write_fds)[i].event_mask = 0x0002;
		}
		params.write_list = *write_fds;
		params.write_count = count_nonzero_fds(num_fds, write_fds);
	}
	if(except_fds != NULL)
	{
		for(i = 0; i < num_fds; i++)
		{
			if((*except_fds)[i].winsock_handle != 0)
/* 0x0020 = FD_CLOSE */
				(*except_fds)[i].event_mask = 0x0020;
		}
		params.except_list = *except_fds;
		params.except_count = count_nonzero_fds(num_fds, except_fds);
	}
	i = call_wsock_vxd(0x10B, &params, sizeof(params));
	if(i == 0)
	{
		if(read_fds != NULL)
			i += count_nonzero_fds(num_fds, read_fds);
		if(write_fds != NULL)
			i += count_nonzero_fds(num_fds, write_fds);
		if(except_fds != NULL)
			i += count_nonzero_fds(num_fds, except_fds);
	}
	return i;
}
#endif
/*****************************************************************************
xxx - malloc() return value?
*****************************************************************************/
#include <stdio.h> /* sprintf() */
char *inet_ntoa(struct in_addr who)
{
	static char rv[16];
/**/
	unsigned b3, b2, b1, b0;

	b0 = (unsigned)who.s_addr & 0xFF;
	who.s_addr >>= 8;
	b1 = (unsigned)who.s_addr & 0xFF;
	who.s_addr >>= 8;
	b2 = (unsigned)who.s_addr & 0xFF;
	who.s_addr >>= 8;
	b3 = (unsigned)who.s_addr & 0xFF;
	sprintf(rv, "%u.%u.%u.%u", b0, b1, b2, b3);
	return rv;
}
