/*****************************************************************************
Socket library for Turbo C and 16-bit Watcom C that calls WSOCK[2].VXD

This code must be run inside a Windows 9x DOS box, preferably Win95
(WinSock version 1). It will not work in a Windows NT/2k/XP DOS box.

Copyright (C) 2003 by Chris Giese
<geezer@execpc.com>, http://my.execpc.com/~geezer

Based on Berci Gabor's Turbo Pascal code for accessing WSOCK2.VXD
http://www.phekda.freeserve.co.uk/gabor/ws2dos/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************************/
#ifndef __SOCKET_H
#define	__SOCKET_H

#ifdef __cplusplus
extern "C"
{
#endif

#if 0
/* C99 fixed-width types */
#include <stdint.h>
#else
typedef unsigned short	uint16_t;
typedef unsigned long	uint32_t;
#endif

/* for little-endian CPU like x86 */
#define	htons(X)	swap16(X)
#define	ntohs(X)	swap16(X)
#define	htonl(X)	swap32(X)
#define	ntohl(X)	swap32(X)

#define	MAX_SOX		32

/* address families */
#define	AF_UNSPEC	0
#define	AF_UNIX		1	/* for inter-process communication (IPC) */
#define	AF_INET		2	/* The Internet(TM) */

/* socket types */
#define	SOCK_STREAM	1	/* for TCP/IP, this is TCP */
#define	SOCK_DGRAM	2	/* for TCP/IP, this is UDP */
#define	SOCK_RAW	3

#define	INADDR_ANY	0uL	/* specific to TCP/IP */

#pragma pack(1)
struct in_addr			/* specific to TCP/IP */
{/* MUST BE 4 BYTES */
	uint32_t s_addr;
};

#pragma pack(1)
struct sockaddr_in		/* specific to TCP/IP */
{/* MUST BE 16 BYTES */
	uint16_t sin_family;
	uint16_t sin_port;
	struct in_addr sin_addr;
	char sin_zero[8];
};

#pragma pack(1)
struct sockaddr
{/* MUST BE 16 BYTES */
	uint16_t sa_family;
	char sa_data[14];
};

struct  hostent
{
	char  *h_name;
	char  **h_aliases;
	short h_addrtype;
	short h_length;
	char  **h_addr_list;
};
#define h_addr h_addr_list[0]

struct hostent *gethostbyname(const char *name);

#if !defined(__DJGPP__)
/* for select(): */
struct timeval
{
	long tv_sec, tv_usec;
};

/* for select(). Do not change the layout of this structure,
because the WSOCK.VXD select() function depends on it . */
#pragma pack(1)
typedef struct
{
	uint32_t winsock_handle;
/* see FD_... constants in WINSOCK.H */
	uint32_t event_mask;
	uint32_t context;
} fd_set[MAX_SOX];

void FD_ZERO(fd_set *arg);
void FD_SET(int s, fd_set *arg);
int select(int numfds, fd_set *read_fds, fd_set *write_fds,
		fd_set *except_fds, struct timeval *timeout);
#endif

unsigned swap16(unsigned arg);
unsigned long swap32(unsigned long arg);

int socket(int family, int type, int protocol);
int bind(int s, const struct sockaddr *my_adr, int adr_len);
int listen(int s, int backlog);
int accept(int s, struct sockaddr *their_adr, int *adr_len);
int recv(int s, char *buf, int max_len, int flags);
int send(int s, const char *buf, int len, int flags);
int connect(int s, const struct sockaddr *their_adr, int adr_len);
int shutdown(int s, int how);
int closesocket(int s);

int sendto(int s, const char *buf, int buf_len, int flags,
		const struct sockaddr *their_adr, int adr_len);
int recvfrom(int s, char *buf, int max_buf_len, int flags,
		struct sockaddr *their_adr, int *adr_len);

char *inet_ntoa(struct in_addr who);

//int recvfrom(int,char*,int,int,struct sockaddr*,int*);
//int sendto(int,const char*,int,int,const struct sockaddr*,int);
//int setsockopt(int,int,int,const char*,int);
//int getpeername(int,struct sockaddr*,int*);
//int getsockname(int,struct sockaddr*,int*);
//int getsockopt(int,int,int,char*,int*);
//unsigned long inet_addr(const char*);
//char * inet_ntoa(struct in_addr);

//htons

#ifdef __cplusplus
}
#endif

#endif

