%macro	EXPORT	$1
	GLOBAL $%1
	$%1:
	GLOBAL $_%1
	$_%1:
%endmacro

%macro	IMPORT 1
%ifdef UNDERBARS
	EXTERN _%1		; GCC for DOS (DJGPP; COFF)
	%define %1 _%1
%else
	EXTERN $%1		; GCC for Linux (ELF)
%endif
%endmacro

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; real-mode code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

[SECTION .text]
[BITS 16]

GLOBAL entry
entry:
	mov ax,[es:0]		; check for DOS PSP
	cmp ax,20CDh		; "INT 20h"
	jne no_dos
	inc byte [dos]		; this code loaded from DOS
	jmp short entry2
no_dos:
	mov ax,cs		; this code loaded from bootloader
	mov ds,ax
	mov es,ax
entry2:				; check for 32-bit CPU
	pushf
		pushf
		pop bx		; old FLAGS -> BX
		mov ax,bx
		xor ah,70h	; try changing b14 (NT)...
		push ax		; ... or b13:b12 (IOPL)
		popf
		pushf
		pop ax		; new FLAGS -> AX
	popf
	xor ah,bh		; 32-bit CPU if we changed NT...
	mov si,cpu_msg
	and ah,70h		; ...or IOPL
	jne cpu_ok
	mov si,cpu_msg
die:				; display error message
	mov ah,0Eh		; INT 10h: teletype output
	xor bx,bx		; video page 0
	jmp die3
die2:
	int 10h
die3:
	lodsb
	or al,al
	jne die2

	xor ax,ax		; exit
	or al,[dos]
	jne dos_exit

	mov ah,0		; await key pressed
	int 16h

	int 19h			; reboot
dos_exit:
	mov ax,4C01h		; DOS terminate
	int 21h
cpu_ok:
	smsw ax			; check for virtual 8086 mode
	test al,1		; look at PE bit of MSW (CR0)
	mov si,v86_msg
	jne die

; patch things that depend on the load adr
	xor ebp,ebp
	mov bp,cs
	shl ebp,4
	mov [_virt_to_phys],ebp

	mov eax,ebp
	mov [gdt2 + 2],ax
	mov [gdt3 + 2],ax
	shr eax,16
	mov [gdt2 + 4],al
	mov [gdt3 + 4],al
	mov [gdt2 + 7],ah
	mov [gdt3 + 7],ah

	add [gdt_ptr + 2],ebp
	add [idt_ptr + 2],ebp

	push dword 0		; interrupts off
	popfd

	lgdt [gdt_ptr]		; enter pmode
	mov ebx,cr0
	inc bx
	mov cr0,ebx

	mov ax,SYS_DATA_SEL	; load all segment registers
	mov ds,ax
	mov ss,ax
	mov es,ax
	mov fs,ax
	mov gs,ax
	jmp SYS_CODE_SEL:dword pmode

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; pmode code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

[SECTION .text]
[BITS 32]

pmode:
	mov esp,stack

; zero kernel .bss
; 'edata' and 'end' are defined in the linker script file (coffkrnl.ld)
IMPORT edata
IMPORT end
	mov edi,edata
	mov ecx,end
	sub ecx,edi
	xor eax,eax
	rep stosb

; set up interrupt handlers
	mov ecx,(idt_end - idt) >> 3 ; number of exception handlers
	mov ebx,idt
	mov edx,isr0
do_idt:
	mov eax,edx		; EAX=offset of entry point
	mov [ebx],ax		; set low 16 bits of gate offset
	shr eax,16
	mov [ebx + 6],ax	; set high 16 bits of gate offset
	add ebx,8		; 8 bytes/interrupt gate
	add edx,(isr1 - isr0)	; bytes/stub
	loop do_idt

; NOTE: the address of the IDT, stored at [idt_ptr + 2],
; was converted to a linear address above
	lidt [idt_ptr]

IMPORT main
	call main		; call C code
	jmp $			; freeze

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			save_vector
; action:		pmode getvect()
; in:			C args pushed on stack (see prototype)
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		'386
; notes:		C prototype:
;			void save_vector(vector_t *vec, unsigned num);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

EXPORT save_vector
	push ebp
		mov ebp,esp
		push esi
		push edi
			mov edi,[ebp + 8]		; vec
			movzx eax,byte [ebp + 12]	; num
			mov ah,(isr1 - isr0)		; bytes/stub
			mul ah
			mov esi,isr0
			add esi,eax

; MOV EAX,nnnn is a 5-byte instruction
; +1 to point to 4-byte operand
			mov eax,[esi + (isr0.1 + 1 - isr0)]
			mov [edi + 0],eax
		pop edi
		pop esi
	pop ebp
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			install_handler
; action:		pmode setvect()
; in:			C args pushed on stack (see prototype)
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		'386
; notes:		C prototype:
;	void install_handler(vector_t *vec, unsigned num, void (*handler)());
;
; 'vec' is not used here, but it is included as an argument
; for compatability with other OSes and environments
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

EXPORT install_handler
	push ebp
		mov ebp,esp
		push edi
			movzx eax,byte [ebp + 12]	; num
			mov ah,(isr1 - isr0)		; bytes/stub
			mul ah
			mov edi,isr0
			add edi,eax
			mov eax,[ebp + 16]		; handler
			mov [edi + (isr0.1 + 1 - isr0)],eax
		pop edi
	pop ebp
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			restore_vector
; action:
; in:			C args pushed on stack (see prototype)
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		'386
; notes:		C prototype:
;			void restore_vector(vector_t *vec, unsigned num);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

EXPORT restore_vector
	push ebp
		mov ebp,esp
		push edi
		push esi
			mov esi,[ebp + 8]		; vec
			movzx eax,byte [ebp + 12]	; num
			mov ah,(isr1 - isr0)		; bytes/stub
			mul ah
			mov edi,isr0
			add edi,eax
			mov eax,[esi + 0]
			mov [edi + (isr0.1 + 1 - isr0)],eax
		pop esi
		pop edi
	pop ebp
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt/exception handlers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

%macro STUB 1
	push byte 0		; "fake" error code
	push byte %1		; exception number
	push gs			; push segment registers
	push fs
	push es
	push ds
	pusha			; push EDI,ESI,EBP,ESP,EBX,EDX,ECX,EAX

; put known-good values in seg regs
		mov ax,SYS_DATA_SEL
		mov ds,eax
		mov es,eax
		mov fs,eax
		mov gs,eax
.1:
		mov eax,do_nothing ; default "handler"
		call eax	; use EAX for absolute call vs. EIP-relative

	popa			; pop GP registers
	pop ds			; pop segment registers
	pop es
	pop fs
	pop gs
	add esp,8		; drop exception number and error code
	iret
%endmacro

; for exceptions that push their own error code on the stack
%macro STUB_EC 1
	nop			; to make this the same size as STUB
	nop
	push byte %1		; exception number
	push gs			; push segment registers
	push fs
	push es
	push ds
	pusha			; push EDI,ESI,EBP,ESP,EBX,EDX,ECX,EAX

; put known-good values in seg regs
		mov ax,SYS_DATA_SEL
		mov ds,eax
		mov es,eax
		mov fs,eax
		mov gs,eax
.1:
		mov eax,do_nothing ; default "handler"
		call eax	; use EAX for absolute call vs. EIP-relative

	popa			; pop GP registers
	pop ds			; pop segment registers
	pop es
	pop fs
	pop gs
	add esp,8		; drop exception number and error code
	iret
%endmacro

do_nothing:
	ret

isr0:				; zero divide (fault)
	STUB 0
isr1:				; debug/single step
	STUB 1
isr2:				; non-maskable interrupt (trap)
	STUB 2
isr3:				; INT3 (trap)
	STUB 3
isr4:				; INTO (trap)
	STUB 4
isr5:				; BOUND (fault)
	STUB 5
isr6:				; invalid opcode (fault)
	STUB 6
isr7:                           ; coprocessor not available (fault)
	STUB 7
isr8:                           ; double fault (abort w/ error code)
	STUB_EC 8
isr9:                           ; coproc segment overrun (abort; 386/486SX only)
	STUB 9
isr0A:                          ; bad TSS (fault w/ error code)
	STUB_EC 0Ah
isr0B:                          ; segment not present (fault w/ error code)
	STUB_EC 0Bh
isr0C:                          ; stack fault (fault w/ error code)
	STUB_EC 0Ch
isr0D:                          ; GPF (fault w/ error code)
	STUB_EC 0Dh
isr0E:                          ; page fault
	STUB_EC 0Eh
isr0F:                          ; reserved
	STUB 0Fh
isr10:				; FP exception/coprocessor error (trap)
	STUB 10h
isr11:                          ; alignment check (trap; 486+ only)
	STUB 11h
isr12:                          ; machine check (Pentium+ only)
	STUB 12h
isr13:
	STUB 13h
isr14:
	STUB 14h
isr15:
	STUB 15h
isr16:
	STUB 16h
isr17:
	STUB 17h
isr18:
	STUB 18h
isr19:
	STUB 19h
isr1A:
	STUB 1Ah
isr1B:
	STUB 1Bh
isr1C:
	STUB 1Ch
isr1D:
	STUB 1Dh
isr1E:
	STUB 1Eh
isr1F:
	STUB 1Fh

; isr20 through isr2F are hardware interrupts. The 8259 programmable
; interrupt controller (PIC) chips must be reprogrammed to make these work.
isr20:				; IRQ 0/timer interrupt
	STUB 20h
isr21:                          ; IRQ 1/keyboard interrupt
	STUB 21h
isr22:
	STUB 22h
isr23:
	STUB 23h
isr24:
	STUB 24h
isr25:
	STUB 25h
isr26:                          ; IRQ 6/floppy interrupt
	STUB 26h
isr27:
	STUB 27h
isr28:                          ; IRQ 8/real-time clock interrupt
	STUB 28h
isr29:
	STUB 29h
isr2A:
	STUB 2Ah
isr2B:
	STUB 2Bh
isr2C:
	STUB 2Ch
isr2D:                          ; IRQ 13/math coprocessor interrupt
	STUB 2Dh
isr2E:                          ; IRQ 14/primary ATA ("IDE") drive interrupt
	STUB 2Eh
isr2F:                          ; IRQ 15/secondary ATA drive interrupt
	STUB 2Fh
isr30:				; syscall software interrupt
	STUB 30h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

[SECTION .data]

dos:
	db 0

EXPORT _virt_to_phys
	dd 0

cpu_msg:
	db "Sorry, 32-bit CPU required", 13, 10, 0
v86_msg:
	db "Sorry, CPU is in Virtual 8086 mode "
	db "(Windows DOS box or EMM386 loaded)", 13, 10, 0

; 32 ring 0 interrupt gates
idt:
	times 48	dw 0, SYS_CODE_SEL, 8E00h, 0

; one ring 3 interrupt gate for syscalls (INT 30h)
	dw 0		; offset 15:0
	dw SYS_CODE_SEL	; selector
	db 0		; (always 0 for interrupt gates)
	db 0EEh		; present,ring 3,'386 interrupt gate
	dw 0		; offset 31:16

idt_end:

idt_ptr:
	dw idt_end - idt - 1	; IDT limit
	dd idt			; linear adr of IDT (set above)

; null descriptor. gdt_ptr could be put here to save a few
; bytes, but that can be confusing.
gdt:
	dw 0		; limit 15:0
	dw 0		; base 15:0
	db 0		; base 23:16
	db 0		; type
	db 0		; limit 19:16, flags
	db 0		; base 31:24

; linear data segment descriptor
LINEAR_SEL	equ	$-gdt
	dw 0FFFFh	; limit 0FFFFFh (1 meg or 4 gig)
	dw 0		; base for this one is always 0
	db 0
	db 92h		; present,ring 0,data,expand-up,writable
	db 0CFh		; page-granular (4 gig limit), 32-bit
	db 0

; ring 0 kernel code segment descriptor
SYS_CODE_SEL	equ	$-gdt
gdt2:
	dw 0FFFFh
	dw 0		; (base gets set above)
	db 0
	db 9Ah		; present,ring 0,code,non-conforming,readable
	db 0CFh
	db 0

; ring 0 kernel data segment descriptor
SYS_DATA_SEL	equ	$-gdt
gdt3:
	dw 0FFFFh
	dw 0		; (base gets set above)
	db 0
	db 92h		; present,ring 0,data,expand-up,writable
	db 0CFh
	db 0
gdt_end:

gdt_ptr:
	dw gdt_end - gdt - 1		; GDT limit
	dd gdt				; linear adr of GDT (set above)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

[SECTION .bss]

	resd 1024
stack:
