; NASM's equivalents of setvect() and getvect()
; Written by Martin Coleman (martin@moedos.net)
; Updated: 4/02/02
; * After a few failed compiles, I got it working. Hope you like it Chris!

SEGMENT _TEXT PUBLIC CLASS=CODE USE16

GLOBAL	_getvect
GLOBAL	_setvect

_getvect:
	push bp
	mov bp, sp
	push    si
	push    di
	push	ds
	push    es
	push bx
; set ES to zero, so it points to the interrupt vector table at 0000:0000
		xor bx,bx
		mov es,bx
		mov bx,[ss:bp+4]
; x4 because each IVT entry (a far address) is 4 bytes long
		shl bx,1
		shl bx,1
; now ES:BX points to the vector we want; IVT[num].
; Read the 32-bit vector (segment + offset) 'atomically',
; without an interrupt happening in the middle of the read.
		les bx,[es:bx]
; return 32-bit far address in DX:AX
		mov dx,es
		mov ax,bx

	pop bx
	pop     es
	pop	ds
	pop     di
	pop     si
	pop     bp
	ret

_setvect:
	push bp
	mov bp, sp
	push    si
	push    di
	push	ds
	push    es
	push bx
; set ES to zero, so it points to the interrupt vector table at 0000:0000
		xor bx,bx
		mov es,bx
		mov bx,[ss:bp+4]
; x4 because each IVT entry (a far address) is 4 bytes long
		shl bx,1
		shl bx,1
; I don't think 8088 or 80286 can do a 32-bit store,
; so shut off interrupts and store 16 bits at a time.
		pushf
			cli
			mov ax,word [ss:bp+6]
			mov [es:bx],ax
			mov ax,word [ss:bp+6+2]
			mov [es:bx+2],ax
		popf
	pop bx
	pop     es
	pop	ds
	pop     di
	pop     si
	pop     bp
	ret

;eof